#ifndef DS3_DISJOINTSET
#define DS3_DISJOINTSET

#include <cstddef>
#include <memory>
#include <vector>

#include "ds3/DisjointSet/common/DisjointSetNode.h"

namespace ds3
{
template <class T>
class DisjointSet
{
 public:
  typedef DisjointSetNode<T> Node;
  typedef const T* const_pointer;
  typedef const T& const_reference;
  typedef T* pointer;
  typedef T& reference;
  typedef std::ptrdiff_t difference_type;
  typedef std::size_t size_type;
  typedef T value_type;

  DisjointSet();
  ~DisjointSet();

  bool empty() const;
  size_type size() const;
  size_type capacity() const;
  const_reference front() const;
  const_reference back() const;
  const_reference operator[](size_type index) const;
  Node* const* beginBlock() const;
  Node* const* endBlock() const;

  reference front();
  reference back();
  reference operator[](size_type index);
  void reserve(size_type newCapacity);
  void push_back(const value_type& newElement);
  void clear();
  void unionByRank(Node* a, Node* b);
  void flatten();
  Node** beginBlock();
  Node** endBlock();
  Node* findRoot(Node* n);

 private:
  typedef typename Node::Index Index;
  typedef std::vector<Node*> NodeVector;

  Node* _findRoot(Node* n);
  void _unionByRank(Node* a, Node* b);
  Node* _createNode(const value_type& element, Index index);
  void _destroyNode(Node* n);
  void _destroyAllNodes();

  NodeVector _nodes;
  std::allocator<Node> _alloc;
};

template <class T>
inline void DisjointSet<T>::unionByRank(Node* a, Node* b)
{
  _unionByRank(a, b);
}
};

#include "ds3/DisjointSet/common/memberFunctions_1.h"

#endif // DS3_DISJOINTSET

// For the book "C++ Data Structures from Scratch, Vol. 3"
// www.cppdatastructures.com
// Copyright 2021 by Robert MacGregor.  All rights reserved.