#include "ds2/Traceable/1/Traceable.h"

#include "ds3/DisjointSet/1/DisjointSet.h"
#include "ds3/printDisjointSet/printDisjointSet.h"

int main()
{
  using namespace std;
  using namespace ds2;
  using namespace ds3;

  typedef DisjointSet<Traceable<char>> DisjointSet;
  typedef DisjointSet::Node Node;

  DisjointSet d;
  d.reserve(7);

  d.push_back('a');
  d.push_back('b');
  d.push_back('c');
  d.push_back('w');
  d.push_back('x');
  d.push_back('y');
  d.push_back('z');
  printDisjointSet(d);

  Node** p = d.beginBlock();

  d.unionByRank(*(p + 0), *(p + 1));
  printDisjointSet(d);

  d.unionByRank(*(p + 1), *(p + 2));
  printDisjointSet(d);

  d.unionByRank(*(p + 3), *(p + 4));
  printDisjointSet(d);

  d.unionByRank(*(p + 5), *(p + 6));
  printDisjointSet(d);

  d.unionByRank(*(p + 4), *(p + 6));
  printDisjointSet(d);

  d.unionByRank(*(p + 1), *(p + 3));
  printDisjointSet(d);

  return 0;
}

// For the book "C++ Data Structures from Scratch, Vol. 3"
// www.cppdatastructures.com
// Copyright 2021 by Robert MacGregor.  All rights reserved.