#ifndef DS3_DISJOINTSETNODE
#define DS3_DISJOINTSETNODE

#include <cstddef>

namespace ds3
{
template <class T>
struct DisjointSetNode
{
  typedef T value_type;
  typedef std::size_t Index;
  typedef std::size_t Rank;
  typedef DisjointSetNode Node;

  DisjointSetNode(const value_type& element, Index index);

  bool isRoot() const;

  value_type element;
  Index index;
  Node* parent;
  Rank rank;
};

template <class T>
inline DisjointSetNode<T>::DisjointSetNode(const value_type& element, Index index):
  element(element),
  index(index),
  parent(nullptr),
  rank(0)
{
  // ...
}

template <class T>
inline bool DisjointSetNode<T>::isRoot() const
{
  return parent == nullptr;
}
};

#endif // DS3_DISJOINTSETNODE

// For the book "C++ Data Structures from Scratch, Vol. 3"
// www.cppdatastructures.com
// Copyright 2021 by Robert MacGregor.  All rights reserved.