namespace ds3
{
template <class T>
inline DisjointSet<T>::DisjointSet()
{
  // ...
}

template <class T>
inline DisjointSet<T>::~DisjointSet()
{
  _destroyAllNodes();
}

template <class T>
inline bool DisjointSet<T>::empty() const
{
  return _nodes.empty();
}

template <class T>
inline typename DisjointSet<T>::size_type DisjointSet<T>::size() const
{
  return _nodes.size();
}

template <class T>
inline typename DisjointSet<T>::size_type DisjointSet<T>::capacity() const
{
  return _nodes.capacity();
}

template <class T>
inline typename DisjointSet<T>::const_reference DisjointSet<T>::front() const
{
  return _nodes.front()->element;
}

template <class T>
inline typename DisjointSet<T>::const_reference DisjointSet<T>::back() const
{
  return _nodes.back()->element;
}

template <class T>
inline typename DisjointSet<T>::const_reference DisjointSet<T>::operator[](
  size_type index) const
{
  return _nodes[index]->element;
}

template <class T>
inline typename DisjointSet<T>::Node* const* DisjointSet<T>::beginBlock() const
{
  return const_cast<DisjointSet*>(this)->beginBlock();
}

template <class T>
inline typename DisjointSet<T>::Node* const* DisjointSet<T>::endBlock() const
{
  return const_cast<DisjointSet*>(this)->endBlock();
}

template <class T>
inline typename DisjointSet<T>::reference DisjointSet<T>::front()
{
  return _nodes.front()->element;
}

template <class T>
inline typename DisjointSet<T>::reference DisjointSet<T>::back()
{
  return _nodes.back()->element;
}

template <class T>
inline typename DisjointSet<T>::reference DisjointSet<T>::operator[](
  size_type index)
{
  return _nodes[index]->element;
}

template <class T>
inline void DisjointSet<T>::reserve(size_type newCapacity)
{
  _nodes.reserve(newCapacity);
}

template <class T>
inline void DisjointSet<T>::push_back(const value_type& newElement)
{
  _nodes.push_back(_createNode(newElement, _nodes.size()));
}

template <class T>
inline void DisjointSet<T>::clear()
{
  _destroyAllNodes();
  _nodes.clear();
}

template <class T>
inline void DisjointSet<T>::flatten()
{
  for (Node* n : _nodes)
    _findRoot(n);
}

template <class T>
inline typename DisjointSet<T>::Node** DisjointSet<T>::beginBlock()
{
  return &_nodes.front();
}

template <class T>
inline typename DisjointSet<T>::Node** DisjointSet<T>::endBlock()
{
  return &_nodes.back() + 1;
}

template <class T>
inline typename DisjointSet<T>::Node* DisjointSet<T>::findRoot(Node* n)
{
  return _findRoot(n);
}

template <class T>
typename DisjointSet<T>::Node* DisjointSet<T>::_findRoot(Node* n)
{
  if (!n->isRoot())
  {
    n->parent = _findRoot(n->parent);
    return n->parent;
  }

  return n;
}

template <class T>
void DisjointSet<T>::_unionByRank(Node* a, Node* b)
{
  Node* x = _findRoot(a);
  Node* y = _findRoot(b);

  if (x == y)
    return;

  if (x->rank < y->rank)
    x->parent = y;
  else
    y->parent = x;

  if (x->rank == y->rank)
    ++x->rank;
}

template <class T>
inline typename DisjointSet<T>::Node* DisjointSet<T>::_createNode(
  const value_type& element,
  Index index)
{
  Node* newNode = _alloc.allocate(1);
  _alloc.construct(newNode, Node(element, index));

  return newNode;
}

template <class T>
inline void DisjointSet<T>::_destroyNode(Node* n)
{
  _alloc.destroy(n);
  _alloc.deallocate(n, 1);
}

template <class T>
inline void DisjointSet<T>::_destroyAllNodes()
{
  for (Node* n : _nodes)
    _destroyNode(n);
}
};

// For the book "C++ Data Structures from Scratch, Vol. 3"
// www.cppdatastructures.com
// Copyright 2021 by Robert MacGregor.  All rights reserved.