#ifndef DS3_PRINTDISJOINTSET
#define DS3_PRINTDISJOINTSET

#include <iostream>

namespace ds3
{
template <class DisjointSet>
void printDisjointSet(DisjointSet& d);

template <class DisjointSet>
void printDisjointSet(DisjointSet& d)
{
  using namespace std;

  typedef typename DisjointSet::Node Node;

  cout << "(index element root rank):\n";

  for (Node** p = d.beginBlock(); p != d.endBlock(); ++p)
  {
    Node* n = *p;

    cout << n->index << " ";
    cout << n->element << " ";
    cout << d.findRoot(n)->element;

    if (n->isRoot())
      cout << " " << d.findRoot(n)->rank;

    cout << endl;
  }

  cout << endl;
}
};

#endif // DS3_PRINTDISJOINTSET

// For the book "C++ Data Structures from Scratch, Vol. 3"
// www.cppdatastructures.com
// Copyright 2021 by Robert MacGregor.  All rights reserved.